<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include PHPMailer classes
require 'vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Set recipient email
    $to_email = "jabir@totallytech.co"; // Replace with your email

    $name = htmlspecialchars(strip_tags($_POST["fullName"]));
    $company = htmlspecialchars(strip_tags($_POST["company"]));
    $email = filter_var($_POST["email"], FILTER_SANITIZE_EMAIL);
    $phone = filter_var($_POST["phone"], FILTER_SANITIZE_NUMBER_INT);
    $project = htmlspecialchars(strip_tags($_POST["project"]));
    $budget = htmlspecialchars(strip_tags($_POST["budget"]));
    $message = htmlspecialchars(strip_tags($_POST["message"]));

    // Instantiate PHPMailer
    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com'; // Set the SMTP server to send through
        $mail->SMTPAuth = true;
        $mail->Username = 'harissultan512@gmail.com'; // SMTP username
        $mail->Password = 'onif vtdx zmpp qwlb'; // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // Load email template for receiver
        $template = file_get_contents('email_template.html');
        $template = str_replace('{{message}}', $message, $template);
        $template = str_replace('{{name}}', $name, $template);
        $template = str_replace('{{company}}', $company, $template);
        $template = str_replace('{{email}}', $email, $template);
        $template = str_replace('{{phone}}', $phone, $template);
        $template = str_replace('{{project}}', $project, $template);
        $template = str_replace('{{budget}}', $budget, $template);

        // Send email to receiver
        $mail->setFrom($email, $name);
        $mail->addAddress($to_email);
        $mail->isHTML(true);
        $mail->Subject = 'Contact Form Submission';
        $mail->Body    = $template;

        $mail->send();

        // Send thank you email to sender
        $mail->clearAddresses();
        $mail->addAddress($email);
        $mail->Subject = 'Thank You for Contacting Us';

        $thankYouTemplate = file_get_contents('thankyou.html');
        $thankYouTemplate = str_replace('{{name}}', $name, $thankYouTemplate);

        $mail->Body = $thankYouTemplate;
        $mail->send();

        // Redirect to contact-us.html
        header('Location: contact-us.html');
        exit;

    } catch (Exception $e) {
        echo json_encode(['type' => 'error', 'text' => 'Mailer Error: ' . $mail->ErrorInfo]);
    }
}
?>
