
window.onscroll = function () {
  scrollFunction();
};

function scrollFunction() {
  var btn = document.getElementById("btn-back-to-top");
  if (
    document.body.scrollTop > 20 ||
    document.documentElement.scrollTop > 20
  ) {
    btn.style.display = "block";
  } else {
    btn.style.display = "none";
  }
}

function changeKeywordsForSEO(lang) {
  if (lang === 'ar') {
    document.querySelector('meta[name="keywords"]').setAttribute('content', 'تطوير البرمجيات عمان, حلول البرمجيات المخصصة عمان, تطوير تطبيقات الجوال عمان, خدمات تكنولوجيا المعلومات عمان, TotallyTech عمان, شركة تطوير البرمجيات عمان, تطوير المواقع عمان, حلول تكنولوجيا عمان, أفضل مطوري البرمجيات عمان, خدمات البرمجيات عمان');
    document.querySelector('meta[name="description"]').setAttribute('content', 'اكتشف خدمات تطوير البرمجيات المميزة في عمان مع TotallyTech. من حلول البرمجيات المخصصة إلى تطوير تطبيقات الجوال، يقدم فريقنا الخبير حلول تكنولوجية عالية الجودة لتلبية احتياجات أعمالك.');
    document.title = 'أفضل خدمات تطوير البرمجيات في عُمان | توتالي تيك';

    document.documentElement.setAttribute('lang', 'ar');
  } else if (lang === 'en') {
    document.querySelector('meta[name="keywords"]').setAttribute('content', 'Software Development Oman, Custom Software Solutions Oman, Mobile App Development Oman, IT Services Oman, TotallyTech Oman, Software Development Company Oman, Web Development Oman, Technology Solutions Oman, Best Software Developers Oman, Oman Software Services');
    document.querySelector('meta[name="description"]').setAttribute('content', 'Discover premium software development services in Oman with TotallyTech. From custom software solutions to mobile app development, our expert team delivers top-notch technology solutions to meet your business needs.');
    document.title = 'Top Software Development Services in Oman | TotallyTech';
    document.documentElement.setAttribute('lang', 'en');
  }

}




function backToTop() {
  document.body.scrollTop = 0;
  document.documentElement.scrollTop = 0;
}




function changeLanguage(lang) {
  // Fetch the appropriate language JSON file based on the selected language
  fetch(`locales/${lang}.json`)
    .then(response => response.json())
    .then(data => {
      // Loop through all elements that have a data-i18n attribute
      const elements = document.querySelectorAll('[data-translate]');
      elements.forEach(element => {
        const key = element.getAttribute('data-translate'); // Get the key for the translation
        if (data[key]) {
          element.innerHTML = data[key]; // Update the element's content with the translated text
        }
      });
    })
    .catch(error => console.error('Error loading language file:', error));
}

$(document).ready(function () {
  var lang = $("html").attr("lang");
  var mybutton = document.getElementById("btn-back-to-top");
  mybutton.addEventListener("click", backToTop);

  var storelang = localStorage.getItem('lang');
  if (storelang != undefined && lang != storelang) {
    lang = storelang;
    $("html").attr("lang", storelang);
  }

  $("html").attr("dir", lang == 'en' ? 'ltr' : 'rtl');
  document.body.setAttribute('dir', lang == 'en' ? 'ltr' : 'rtl');

  changeLanguage(lang);
  changeKeywordsForSEO(lang);


  document.getElementById('language-toggle').innerText = lang == 'en' ? 'Ar' : 'En';

  var icon = document.getElementById('dark-mode-icon');




  const theme = localStorage.getItem('theme');
  if (theme == 'bg-dark') {
    document.body.classList.add('bg-dark');
    document.body.classList.add('text-light');
    icon.classList.add('bi-sun');
    icon.classList.remove('bi-moon');
  }
  else {
    document.body.classList.remove('bg-dark')
    document.body.classList.remove('text-light');
    icon.classList.add('bi-moon');
    icon.classList.remove('bi-sun');
  }


  document.getElementById('language-toggle').addEventListener('click', function () {
    var currentLanguage = this.innerText;
    if (currentLanguage == 'En') {
      this.innerText = 'Ar';
      lang = 'en';


    } else {
      this.innerText = 'En';
      lang = 'ar';
    }
    localStorage.setItem('lang', lang);

    $("html").attr("lang", lang);
    $("html").attr("dir", lang == 'en' ? 'ltr' : 'rtl');
    document.body.setAttribute('dir', lang == 'en' ? 'ltr' : 'rtl');

    changeLanguage(lang);
    changeKeywordsForSEO(lang);

  });



  // Dark mode toggle
  document.getElementById('dark-mode-toggle').addEventListener('click', function () {
    document.body.classList.toggle('bg-dark');
    document.body.classList.toggle('text-light');

    if (document.body.classList.contains('bg-dark')) {
      localStorage.setItem('theme', 'bg-dark');
      icon.classList.add('bi-sun');
      icon.classList.remove('bi-moon');
    } else {
      localStorage.setItem('theme', 'bg-light');
      icon.classList.add('bi-moon');
      icon.classList.remove('bi-sun');
    }
  });


});


document.addEventListener('DOMContentLoaded', function () {
  fetch('_header.html')
    .then(response => response.text()).then(data => {
      document.getElementById('header').innerHTML = data;

      // Select all dropdown items
      const dropdownItems = document.querySelectorAll('.navbar-nav .dropdown-item');

      dropdownItems.forEach(item => {
        item.addEventListener('click', function () {
          // Remove active class from all nav-links (to reset)
          document.querySelectorAll('.navbar-nav .nav-link').forEach(link => {
            link.classList.remove('active');
          });

          // Add active class to the clicked dropdown item
          this.classList.add('active');

          // Find the parent .nav-item and add active class to the .nav-link inside it
          const parentDropdown = this.closest('.nav-item').querySelector('.nav-link');
          parentDropdown.classList.add('active');
        });
      });

      // Handle page load to mark the active item based on the current URL
      const currentPath = window.location.pathname.replace('/', '');

      // Loop through all the nav links and check if the current path matches
      document.querySelectorAll('.navbar-nav .nav-link').forEach(link => {
        const linkHref = link.getAttribute('href');

        if (currentPath === linkHref || currentPath === linkHref.split('?')[0]) {
          link.classList.add('active');
        } else {
          link.classList.remove('active');
        }
      });

      // Also handle the dropdown items based on the current path
      document.querySelectorAll('.navbar-nav .dropdown-item').forEach(item => {
        const itemHref = item.getAttribute('href');

        if (currentPath === itemHref || currentPath === itemHref.split('?')[0]) {
          item.classList.add('active');
          // Add active class to the parent .nav-link of the dropdown
          const parentDropdown = item.closest('.nav-item').querySelector('.nav-link');
          parentDropdown.classList.add('active');
        } else {
          item.classList.remove('active');
        }
      });
    })
});