// Wait for the DOM to load
document.addEventListener('DOMContentLoaded', () => {
    // Select the div by its id
    const backToTop = document.getElementById('backToTop');

    // Check if the element exists
    if (backToTop) {
        // Add a click event listener to the div
        backToTop.addEventListener('click', () => {
            // Smooth scroll to the top of the page
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
    } else {
        console.error("Element with id 'backToTop' not found in the DOM.");
    }
});


document.addEventListener("scroll", () => {
    const sections = document.querySelectorAll("section"); // Assuming sections are defined with <section> tags
    const navLinks = document.querySelectorAll(".nav-link");
  
    let activeSection = null;
  
    sections.forEach((section) => {
      const rect = section.getBoundingClientRect();
      if (rect.top >= 0 && rect.top <= window.innerHeight / 2) {
        activeSection = section.getAttribute("id");
      }
    });
  
    navLinks.forEach((link) => {
      const href = link.getAttribute("href"); // Get the href attribute
      if (href && href.startsWith("#") && href.substring(1) === activeSection) {
        // Check if href exists, starts with #, and matches the active section
        link.classList.add("active");
        link.style.color = "#000"; // Change the active link color to red
      } else {
        link.classList.remove("active");
        link.style.color = ""; // Reset color for inactive links
      }
    });
  });