function changeKeywordsForSEO(lang) {
  if (lang === 'ar') {
    document.querySelector('meta[name="keywords"]').setAttribute('content', 'جيو جيتسو ياباني في عمان، تدريب جيو جيتسو عمان، مدرسة فنون قتالية عمان، دروس الدفاع عن النفس عمان، جيو جيتسو للمبتدئين عمان، مدربي جيو جيتسو محترفين، دروس فنون قتالية للأطفال في عمان، جيو جيتسو ياباني تقليدي، أفضل مدرسة جيو جيتسو في عمان، تعلم تقنيات الدفاع عن النفس، تدريب كيشيدو في عمان، مؤسسة الجوجيتسو العالمية عمان، ورش عمل جيو جيتسو عمان، برامج فنون قتالية عمان، اللياقة البدنية من خلال جيو جيتسو');
    document.querySelector('meta[name="description"]').setAttribute('content', 'اكتشف فن الجيو جيتسو الياباني في مدرسة الفنون القتالية الرائدة في سلطنة عمان. انضم إلينا للحصول على تدريب بقيادة خبراء في الدفاع عن النفس واللياقة البدنية وتقنيات الكيشيدو. مثالي للمبتدئين والمحترفين!');
    document.title = 'أول مدرسة للجوجيتسو في عُمان';

    document.documentElement.setAttribute('lang', 'ar');
  } else if (lang === 'en') {
    document.querySelector('meta[name="keywords"]').setAttribute('content', 'Japanese Jiu-Jitsu in Oman,Jiu-Jitsu training Oman, Martial arts school Oman,Self-defense classes Oman,Jiu-Jitsu for beginners Oman,Professional Jiu-Jitsu instructors, Martial arts classes for kids in Oman, Traditional Japanese Jiu-Jitsu, Best Jiu-Jitsu school in Oman, Learn self-defense techniques, Kishido training in Oman, World Ju-Jitsu Corporation Oman, Jiu-Jitsu workshops Oman, Martial arts programs Oman, Fitness through Jiu-Jitsu');
    document.querySelector('meta[name="description"]').setAttribute('content', 'Discover the art of Japanese Jiu-Jitsu at Oman’s premier martial arts school. Join us for expert-led training in self-defense, fitness, and Kishido techniques. Perfect for beginners and professionals!');
    document.title = 'First Ju-Jitsu School in Oman';
    document.documentElement.setAttribute('lang', 'en');
  }

}


function changeLanguage(lang) {
  // Fetch the appropriate language JSON file based on the selected language
  fetch(`locals/${lang}.json`)
    .then((response) => response.json())
    .then((data) => {
      // Loop through all elements that have a data-i18n attribute
      const elements = document.querySelectorAll("[data-translate]");
      elements.forEach((element) => {
        const key = element.getAttribute("data-translate"); // Get the key for the translation
        if (data[key]) {
          element.innerHTML = data[key]; // Update the element's content with the translated text
        }
      });
    })
    .catch((error) => console.error("Error loading language file:", error));
}

// image gallery script //

let swiper;

// Function to initialize Swiper
function initializeSwiper() {
  if (swiper) {
    swiper.destroy(true, true); // Destroy the existing Swiper instance
  }

  swiper = new Swiper(`[unique-script-id="w-w-dm-id"] .mySwiper`, {
    slidesPerView: 1.5,
    //isRtl: true,
    centeredSlides: true,
    spaceBetween: 5,
    autoplay: {
      delay: 2500,
      disableOnInteraction: false,
    },
    pagination: {
      el: `[unique-script-id="w-w-dm-id"] .swiper-pagination`,
      clickable: true,
    },
    loop: true,
    navigation: {
      nextEl: `[unique-script-id="w-w-dm-id"] .swiper-button-nexts`,
      prevEl: `[unique-script-id="w-w-dm-id"] .swiper-button-prevs`,
    },
    lazy: {
      loadOnTransitionStart: true, // Load images when transition starts
      loadPrevNext: true, // Load previous/next images
    },
  });

  // Manually trigger lazy loading
  //swiper.load();
}

$(document).ready(function () {
  var lang = $("html").attr("lang");
  //var mybutton = document.getElementById("btn-back-to-top");
  //mybutton.addEventListener("click", backToTop);

  var storelang = localStorage.getItem("lang");
  if (storelang != undefined && lang != storelang) {
    lang = storelang;
    $("html").attr("lang", storelang);
  }

  $("html").attr("dir", lang == "en" ? "ltr" : "rtl");
  document.body.setAttribute("dir", lang == "en" ? "ltr" : "rtl");

  changeLanguage(lang);
   changeKeywordsForSEO(lang);

  document.getElementById("language-toggle").innerText =
    lang == "en" ? "Ar" : "En";

  //document.getElementById('w-w-dm-id').setAttribute('dir', lang == 'en' ? 'ltr' : 'rtl');
  // Call this function initially
  initializeSwiper();
  var icon = document.getElementById("dark-mode-icon");

  const theme = localStorage.getItem("theme");
  if (theme == "bg-dark") {
    document.body.classList.add("bg-dark");
    document.body.classList.add("text-light");
    icon.classList.add("bi-sun");
    icon.classList.remove("bi-moon");
  } else {
    document.body.classList.remove("bg-dark");
    document.body.classList.remove("text-light");
    icon.classList.add("bi-moon");
    icon.classList.remove("bi-sun");
  }

  document
    .getElementById("language-toggle")
    .addEventListener("click", function () {
      var currentLanguage = this.innerText;
      if (currentLanguage == "En") {
        this.innerText = "Ar";
        lang = "en";
      } else {
        this.innerText = "En";
        lang = "ar";
      }
      localStorage.setItem("lang", lang);

      $("html").attr("lang", lang);
      $("html").attr("dir", lang == "en" ? "ltr" : "rtl");
      document.body.setAttribute("dir", lang == "en" ? "ltr" : "rtl");
      //document.getElementById('w-w-dm-id').setAttribute('dir', lang == 'en' ? 'ltr' : 'rtl');
      changeLanguage(lang);
       changeKeywordsForSEO(lang);
      //Call this function initially
      initializeSwiper();
    });

  // Dark mode toggle
  document
    .getElementById("dark-mode-toggle")
    .addEventListener("click", function () {
      document.body.classList.toggle("bg-dark");
      document.body.classList.toggle("text-light");

      if (document.body.classList.contains("bg-dark")) {
        localStorage.setItem("theme", "bg-dark");
        icon.classList.add("bi-sun");
        icon.classList.remove("bi-moon");
      } else {
        localStorage.setItem("theme", "bg-light");
        icon.classList.add("bi-moon");
        icon.classList.remove("bi-sun");
      }
    });
});

document.addEventListener("scroll", () => {
  const sections = document.querySelectorAll("section"); // Assuming sections are defined with <section> tags
  const navLinks = document.querySelectorAll(".nav-link");

  let activeSection = null;

  sections.forEach((section) => {
    const rect = section.getBoundingClientRect();
    if (rect.top >= 0 && rect.top <= window.innerHeight / 2) {
      activeSection = section.getAttribute("id");
    }
  });

  navLinks.forEach((link) => {
    const href = link.getAttribute("href"); // Get the href attribute
    if (href && href.startsWith("#") && href.substring(1) === activeSection) {
      // Check if href exists, starts with #, and matches the active section
      link.classList.add("active");
      link.style.color = "red"; // Change the active link color to red
    } else {
      link.classList.remove("active");
      link.style.color = ""; // Reset color for inactive links
    }
  });
});

// // Add an event listener for language change
// document.querySelector('#languageSwitcher').addEventListener('change', () => {
//     // Update image sources if necessary
//     updateImageSources();

//     // Reinitialize Swiper
//     initializeSwiper();
// });

// // Function to update image sources (if URLs change during language switch)
// function updateImageSources() {
//     document.querySelectorAll(`[unique-script-id="w-w-dm-id"] .mySwiper img`).forEach((img) => {
//         // Update the src or data-src attributes here
//         const newSrc = getNewImageUrl(img.dataset.key); // Example function
//         img.setAttribute('data-src', newSrc);
//     });
// }

// back to top button //

const backToTopBtn = document.getElementById("backToTop");

// Show the button when the user scrolls down 100px
window.onscroll = function () {
  if (
    document.body.scrollTop > 100 ||
    document.documentElement.scrollTop > 100
  ) {
    backToTopBtn.style.display = "block";
  } else {
    backToTopBtn.style.display = "none";
  }
};

// Scroll to top when the button is clicked
backToTopBtn.addEventListener("click", () => {
  window.scrollTo({
    top: 0,
    behavior: "smooth",
  });
});
